<x-app-layout>
    <x-slot name="header">
        State
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        @isset($state->id)
                        Edit State
                        @else
                        Add New State
                        @endisset
                    </div>
                </div>
                <form action="
                    @isset($state->id)
                        {{ route('admin.location.state.update', [$country->id, $state->id]) }}
                    @else
                        {{ route('admin.location.state.store', $country->id) }}
                    @endisset
                    " method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        @isset($state->id)
                        @method('PUT')
                        @endisset
                        @csrf
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="country_id">Country :</label>
                            <div class="">
                                <select name="country_id" id="country_id" class="form-control @error('name') is-invalid @enderror">
                                    <option value="">Select Country</option>
                                    @foreach ($countries as $ctry)
                                    <option value="{{ $ctry->id }}" @selected(old('country_id', $state->country_id) == $ctry->id || $country->id == $ctry->id)>{{ $ctry->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @error('country_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="name">State Name :</label>
                            <div class="">
                                <input type="search" class="form-control @error('name') is-invalid @enderror"
                                    name="name" value="{{ old('name', $state->name) }}" placeholder="State Name">
                            </div>
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="code">State Code :</label>
                            <div class="">
                                <input type="search" class="form-control @error('code') is-invalid @enderror"
                                    name="code" value="{{ old('code', $state->code) }}" placeholder="State code">
                            </div>
                            @error('code')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="status" value="1" class="custom-switch-input" {{ old('status',
                                $state->status) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Status</span>
                        </label>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <a href="{{route('admin.location.state.index', $country->id)}}"
                            class="btn btn-default float-end">Discard</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Row -->
</x-app-layout>
